unit Lista3u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label8: TLabel;
    Tetelek1: TListBox;
    Tetel: TEdit;
    HozzaAd: TButton;
    Kivalaszt: TButton;
    Megszuntet: TButton;
    Osszes: TButton;
    EgyikSem: TButton;
    Torles1: TButton;
    Kilepes: TButton;
    Tetelek2: TListBox;
    KeresPontosan: TButton;
    Keres: TButton;
    Torles2: TButton;
    Feltoltes: TButton;

    procedure KilepesClick(Sender: TObject);
    procedure HozzaAdClick(Sender: TObject);
    procedure KivalasztClick(Sender: TObject);
    procedure MegszuntetClick(Sender: TObject);
    procedure OsszesClick(Sender: TObject);
    procedure EgyikSemClick(Sender: TObject);
    procedure KeresClick(Sender: TObject);
    procedure KeresPontosanClick(Sender: TObject);
    procedure Torles1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Tetelek1Click(Sender: TObject);
    procedure Torles2Click(Sender: TObject);
    procedure FeltoltesClick(Sender: TObject);

  private
  procedure Feltolt(lst: TListBox);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{ a megadott listaablakot feltlt eljrs }
procedure TForm1.Feltolt(lst: TListBox);
var
    i : integer;
begin
   with lst do
   begin
     for i:=1 to 4 do
       Items.Add(chr(48+i)+'. ttel');
     Items.Add('alma');
     Items.Add('anansz');
     Items.Add('stb.');
   end;
end;

{ a "Trls 1" nyomgomb esemnykezel eljrsa }
procedure TForm1.Torles1Click(Sender: TObject);
begin
  // a "Ttelek 1" lista trlse
  Tetelek1.Clear;
  // a "Ttel" szvegmez trlse
  Tetel.Clear;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a "Hozzad" nyomgomb esemnykezel eljrsa }
procedure TForm1.HozzaAdClick(Sender: TObject);
begin
  if Tetel.GetTextLen > 0 then
  // a szvegmez nem res
  begin
    if Tetelek2.Items.IndexOf(Tetel.Text) = -1 then
    // az j ttel hosszadsa a "Ttelek 2" listhoz
       Tetelek2.Items.Add(Tetel.Text);
    if Tetelek1.Items.IndexOf(Tetel.Text) = -1 then
      // az j ttel hosszadsa a "Ttelek 1" listhoz
       Tetelek1.Items.Add(Tetel.Text);
  end;
  // a "Ttel" szvegmez trlse
  Tetel.Clear;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a Form2 objektum ltrehozsakor hvdik meg }
procedure TForm1.FormCreate(Sender: TObject);
begin
  // tbbszrs ttelkivlaszts engedlyezse
  Tetelek1.MultiSelect    := true;
  Tetelek1.ExtendedSelect := true;
  Tetelek2.MultiSelect    := true;
  Tetelek2.ExtendedSelect := true;

// a "Ttelek 1" lista kezdeti feltltse
   Feltolt(Tetelek1);
// a "Ttelek 2" lista kezdeti feltltse
   Feltolt(Tetelek2);
end;

{ a "Keres" nyomgomb esemnykezel eljrsa }
procedure TForm1.KeresClick(Sender: TObject);
var
   i   : integer;
begin
  for i:=0 to Tetelek2.Items.Count-1 do
  begin
     // sszes kivlaszts megszntetse
     // a "Ttelek 2" listban
     Tetelek2.Selected[i] := False;
  end;
  // ttel keresse
  for  i:=0 to Tetelek2.Items.Count-1 do
  begin
     if pos(Tetel.Text,Tetelek2.Items[i]) = 1 then
     begin
       // a szvegmez tartalmval
       // kezdd ttel kijellse
       Tetelek2.Selected[i] := True;
     end;
  end;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a "Keres pontosan" nyomgomb esemnykezel eljrsa }
procedure TForm1.KeresPontosanClick(Sender: TObject);
var
   j : integer;
begin
  // a szvegmezben lev ttel keresse
  for j:=0 to  Tetelek2.Items.Count-1 do
    if Tetel.Text = Tetelek2.Items[j] then
       // a megtallt ttel kijellse
       Tetelek2.Selected[j] := True
       else
       // kivlaszts megszntetse
        Tetelek2.Selected[j] := False;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a "=Kivlaszt=>" nyomgomb esemnykezel eljrsa }
procedure TForm1.KivalasztClick(Sender: TObject);
var
     i, j : integer;
begin
   // a "Ttelek 2" listban a kivlasztsok
   // megszntetse
   for j:=0 to Tetelek2.Items.Count-1 do
     Tetelek2.Selected[j] := False;
   for i:=0 to Tetelek1.Items.Count-1 do
   begin
     if Tetelek1.Selected[i] then
     begin
       // a "Ttelek 1" lista i-edik ttele van kivlasztva
       for j:=0 to Tetelek2.Items.Count-1 do
       begin
         if Tetelek1.Items[i] = Tetelek2.Items[j] then
           // a "Ttelek 2" lista j-edik ttelt vlasztja ki
           Tetelek2.Selected[j] := True;
       end;
     end;
   end;
   // a szvegmez trlse
   Tetel.Clear;
   // a fkusz tlltsa a szvegmezre
   Tetel.SetFocus;
end;

{ a "Megszntet=>" nyomgomb esemnykezel eljrsa }
procedure TForm1.MegszuntetClick(Sender: TObject);
var
    i : integer;
begin
  for i:=0 to Tetelek2.Items.Count-1 do
    Tetelek2.Selected[i] := false;
   // a fkusz tlltsa a szvegmezre
   Tetel.SetFocus;
end;

{ a "sszes=>" nyomgomb esemnykezel eljrsa }
procedure TForm1.OsszesClick(Sender: TObject);
var
   i : integer;
begin
  // a "Ttelek 2" lista sszes elemt kivlasztja
  for i:=0 to Tetelek2.Items.Count-1 do
     Tetelek2.Selected[i] := True;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ ax "Egyik sem=>" nyomgomb esemnykezel eljrsa }
procedure TForm1.EgyikSemClick(Sender: TObject);
var
   i : integer;
begin
  // a "Ttelek 2" lista sszes elemnek
  // kivlasztst megsznteti
  for i:=0 to Tetelek2.Items.Count-1 do
     Tetelek2.Selected[i] := False;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a "Ttelek 1" lista tteln val kattintsra hvdik meg }
procedure TForm1.Tetelek1Click(Sender: TObject);
var
   i : integer;
begin
   for i:=0 to Tetelek1.Items.Count-1 do
   begin
     if Tetelek1.Selected[i] then
     begin
        // a kivlasztott ttel a "Ttel" szvegmezbe
        // kerl
        Tetel.Text := Tetelek1.Items[i];
        break;
     end;
   end;
end;

{ a "Kilps" nyomgomb esemnykezel eljrsa }
procedure TForm1.KilepesClick(Sender: TObject);
begin
   Application.Terminate;
end;

{ a "Trls 2" nyomgomb esemnykezel eljrsa }
procedure TForm1.Torles2Click(Sender: TObject);
begin
  // a "Ttelek 2" lista trlse
  Tetelek2.Clear;
  // a "Ttel" szvegmez trlse
  Tetel.Clear;
  // a fkusz tlltsa a szvegmezre
  Tetel.SetFocus;
end;

{ a "Fekltlts" nyomgomb esemnykezel eljrsa }
procedure TForm1.FeltoltesClick(Sender: TObject);
begin
   Tetelek1.Clear;
   // a "Ttelek 1" lista kezdeti feltltse
   Feltolt(Tetelek1);
end;

end.
